 ; Schlock - warn the user if any layers are frozen, off, or locked.
 ; Copyright 1996 by Rocket Software
 ; A tasteful program for people of refinement.
 (DEFUN C:SCHLOCK (/ reww num lock off froz layy col stat)
  (setq reww T)
  (setq num 0)
  (setq lock 0)
  (setq off 0)
  (setq froz 0)
  (while (setq layy (tblnext "layer" reww))
         (setq reww ())
         (setq num (1+ num))
         (if (and (setq col (cdr (assoc 62 layy)))
                  (minusp col))
             (setq off (1+ off)))
         (if (and (setq stat (cdr (assoc 70 layy)))
                  (= 1 (logand 1 stat)))
             (setq froz (1+ froz)))
         (if (and stat
                  (= 4 (logand 4 stat)))
             (setq lock (1+ lock))))
  (if (< 0 (+ froz lock off))
      (write-line (strcat "\nWarning: "
                          (if (< 0 froz)
                              (strcat (itoa froz) " frozen layer"
                                      (if (= froz 1) "" "s"))
                              "")
                          (if (and (< 0 froz)
                                   (or (< 0 lock) (< 0 off)))
                              ", "
                              "")
                          (if (< 0 lock) (strcat (itoa lock) " locked") "")
                          (if (and (= froz 0) (/= lock 0))
                              (if (= lock 1) " layer" " layers")
                              "")
                          (if (and (< 0 lock) (< 0 off))
                              ", "
                              "")
                          (if (< 0 off) (itoa off) "")
                          (if (and (= froz 0) (= lock 0) (/= off 0))
                              (if (= off 1)
                                  " layer turned off"
                                  " layers turned off")
                                  (if (/= off 0) " off" ""))
                          ". (Total " (itoa num) ")")))
 (princ))